#include <SPI.h>
#include <ESP8266WiFi.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128 // OLED display width, in pixels
#define SCREEN_HEIGHT 64 // OLED display height, in pixels

//Declaration for SSD1306 display connected using software SPI (default case):
#define OLED_MOSI  D6
#define OLED_CLK   D5
#define OLED_DC    D8
#define OLED_CS    12
#define OLED_RESET D7
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT,
  OLED_MOSI, OLED_CLK, OLED_DC, OLED_RESET, OLED_CS);

// Initialize the OLED display SPI
// D5 -> SCL
// D6 -> SDA
// D7 -> RES
// D8 -> DC
// +5v -> VCC
// GND -> GND

void setup() {
  Serial.begin(115200);
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);

  WiFi.mode(WIFI_STA);
  WiFi.disconnect();
  delay(100);
  Serial.println("Setup Complete");
  display.clearDisplay();
  display.display();
}
void loop() {
  
  Serial.println("Scanning Initiated");

  int n = WiFi.scanNetworks();
  Serial.println("Scan Complete");
  if (n == 0) {
    Serial.println("No Networks Found");
  } else {
    Serial.print(n);
    Serial.println(" Networks Found");
    for (int i = 0; i < n; ++i) {
      Serial.print(i + 1);
      Serial.print(": ");
      Serial.print(WiFi.SSID(i));
      Serial.print(" (");
      Serial.print(WiFi.RSSI(i));
      Serial.print(")");
      Serial.println((WiFi.encryptionType(i) == ENC_TYPE_NONE) ? " " : "*");
      delay(10);
      
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(25,0);
  display.print("Networks Found: ");
  display.print(n);
        
  display.setTextSize(1);
  display.setTextColor(SSD1306_WHITE);
  display.setCursor(0,8);
  display.println(WiFi.SSID(0));
  display.println(WiFi.SSID(1));
  display.println(WiFi.SSID(2));
  display.println(WiFi.SSID(3));
  display.println(WiFi.SSID(4));
  display.setCursor(0,0);
  display.display();
  display.clearDisplay();
      
    }
  }
  Serial.println("");
  delay(50);
}
