# Import libraries
from machine import Pin
from onewire import OneWire
from ds18x20 import DS18X20
import utime
from time import sleep
from machine import Pin, I2C, SPI
from lcd_api import LcdApi
from pico_i2c_lcd import I2cLcd
from ssd1306 import SSD1306_SPI

#SPI configuratin for OLED
spi = SPI(0, 400000, mosi=Pin(19), sck=Pin(18))
oled = SSD1306_SPI(128, 64, spi, Pin(21),Pin(20), Pin(16))
#I2C configuratin for LCD
i2c = I2C(0, sda = Pin(0), scl = Pin(1), freq = 400000)
lcd = I2cLcd(i2c, 0x27, 2, 16)

lcd.move_to(0,0)
lcd.putstr(" DS18B20 Sensor")
lcd.move_to(0,1)
lcd.putstr("Raspbery Pi Pico")
sleep(5)

# Initialization GPIO, OneWire and DS18B20
one_wire_bus = Pin(26)
sensor_ds = DS18X20(OneWire(one_wire_bus))

# Discover one-wire devices
devices = sensor_ds.scan()
#print(devices)
lcd.clear()
while True:
    # Measure temperature
    sensor_ds.convert_temp()
    # Query sensors
    for device in devices:
        temp = sensor_ds.read_temp(device)
        temp_C = "{:.1f}".format(temp)
        print('Temperature :', temp_C , '°C')
        temp_f = ((sensor_ds.read_temp(device)) * (9/5) + 32)
        temp_F = "{:.1f}".format(temp_f)
        print('Temperature:', temp_F, '°F \n')

    lcd.move_to(0,0)
    lcd.putstr("Pico DS18B20 Stn")
    lcd.move_to(0,1)
    lcd.putstr("                ")
    lcd.move_to(0,1)
    lcd.putstr("Temp C: ")
    lcd.putstr(str(temp_C))
    lcd.putstr(chr (0xDF) + "C")
    sleep(3)
    lcd.move_to(0,1)
    lcd.putstr("                ")
    lcd.move_to(0,1)
    lcd.putstr("Temp F: ")
    lcd.putstr(str (temp_F))
    lcd.putstr(chr (0xDF) + "F")
    sleep(3)
    oled.fill(0)
    oled.text("Raspberry Pico",10,0)
    oled.text("DS18B20 Sensor", 10,10)
    oled.text("Temp[C]=" + str (temp_C) + " C", 10,30)
    oled.text("Temp[F]=" + str (temp_F) + " F", 10,40)
    oled.show()
    sleep(1.5)