#include <Arduino.h>
#if defined(ESP8266)
  /* ESP8266 Dependencies */
  #include <ESP8266WiFi.h>
  #include <ESPAsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#elif defined(ESP32)
  /* ESP32 Dependencies */
  #include <WiFi.h>
  #include <AsyncTCP.h>
  #include <ESPAsyncWebServer.h>
#endif
#include <ESPDash.h>
#include <OneWire.h>
#include <DallasTemperature.h>

// Data wire is connected to GPIO 2
#define ONE_WIRE_BUS 2

// Setup a oneWire instance to communicate with any OneWire devices
OneWire oneWire(ONE_WIRE_BUS);

// Pass our oneWire reference to Dallas Temperature sensor
DallasTemperature sensors(&oneWire);

/* Your WiFi Credentials */
const char* ssid = "Your WIFI SSID"; // SSID
const char* password = "Your WIFI Password"; // Password

/* Start Webserver */
AsyncWebServer server(80);
/* Attach ESP-DASH to AsyncWebServer */
ESPDash dashboard(&server); 

Card tempC(&dashboard, TEMPERATURE_CARD, "Temperature in C", "°C");
Card tempF(&dashboard, TEMPERATURE_CARD, "Temperature in F", "°F");

void setup() {
  Serial.begin(115200);
  /* Connect WiFi */
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  if (WiFi.waitForConnectResult() != WL_CONNECTED) 
  {
      Serial.printf("WiFi Connection Failed!\n");
      return;
  }
  Serial.println("IP Address: ");
  Serial.println(WiFi.localIP());
  /* Start AsyncWebServer */
  server.begin();
}

void loop() 
{
  sensors.requestTemperatures(); 
  float temperatureC = sensors.getTempCByIndex(0);
    Serial.print("Temp. in Celsius: ");
    Serial.println(temperatureC);
  
  float temperatureF = sensors.getTempFByIndex(0);
    Serial.print("Temp. in Fahrenheit: ");
    Serial.println(temperatureF);
  
  /* Update Card Values */
  tempC.update(temperatureC,"°C");
  tempF.update(temperatureF,"°F");
  /* Send Updates to our Dashboard (realtime) */
  dashboard.sendUpdates();
  delay(3000);
}
