
#define BLYNK_PRINT Serial
#define BLYNK_TEMPLATE_ID "TMPL27Q7pStv"
#define BLYNK_DEVICE_NAME "IoT LPG Gas Detector"
#include <ESP8266WiFi.h>
#include <BlynkSimpleEsp8266.h>
char auth[] = "xxxxxxxxxxxxxxxxxxxxxxxxxxx"; //Enter the auth token
int lpg_sensor = A0; //Connected to A0 pin of NodeMCU
int temp_lpg_sensor;
int led_red = 13; // D7 for visual indiction on gas leak state
int led_green = 14; // D5 for visual indiction during normal state
void setup()
 {
  Serial.begin(9600);
  Blynk.begin(auth, "WIFI_SSID", "WIFI_PASSWORD"); //Enter the WIFI SSID and WIFI Password
  pinMode(led_red, OUTPUT);
  pinMode(led_green, OUTPUT);
  pinMode(lpg_sensor, INPUT);
  digitalWrite(led_red, LOW);
  digitalWrite(led_green, LOW);
  Serial.println("LPG GAS DETECTION");
 }
 void loop()
 {
  Blynk.run(); // Initiates Blynk
  temp_lpg_sensor = analogRead(lpg_sensor);
  Blynk.virtualWrite(V0, temp_lpg_sensor);
  Serial.print("Current Gas Level:");
  Serial.println(temp_lpg_sensor);
  if (temp_lpg_sensor > 800)
  {
    digitalWrite(led_red, HIGH);
    digitalWrite(led_green, LOW);
    Serial.print("WARNING! Alert Gas Leaked");
    Blynk.email("arabindo@gmail.com","notofication","WARNING! Alert Gas Leaked");
    Blynk.logEvent("notification","WARNING! Alert Gas Leaked");
  }
  else
    {
     digitalWrite(led_red, LOW);
     digitalWrite(led_green, HIGH);
    }
  }
