import network
import socket
import time
import dht
import machine
from machine import Pin, I2C
from lcd_api import LcdApi
from pico_i2c_lcd import I2cLcd
import gc
gc.collect()

#I2C configuratin for LCD
i2c = I2C(0, sda = Pin(0), scl = Pin(1), freq = 100000)
lcd = I2cLcd(i2c, 0x27, 2, 16)

lcd.move_to(0,0)
lcd.putstr(" DHT11 Sensor")
lcd.move_to(0,1)
lcd.putstr("with Pi Pico W ")
time.sleep(3)

# Define the pin for DHT11 data
dht_sensor = dht.DHT11(2)

ssid = 'xxxxxxxxxxxxxxx' #Your network name
password = 'xxxxxxxxxxxxxxx' #Your WiFi password

led_onboard = Pin("LED", Pin.OUT)

#Connect to WLAN
wlan = network.WLAN(network.STA_IF)
wlan.active(True)
wlan.connect(ssid, password)
while wlan.isconnected() == False:
    led_onboard.value(1)
    print('Connecting...')
    time.sleep(1)
ip = wlan.ifconfig()[0]
print('Connection successful')
print(f'Connected on {ip}')
led_onboard.value(0)

lcd.clear()
def web_page():
    
    #HTML CODE  
    html = """<html>
    <head>
  <title>Raspberry Pico W Web Server</title>
  <meta http-equiv="refresh" content="10">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
  <link rel="icon" href="data:,">
  <style>
    html {font-family: Arial; display: inline-block; text-align: center;}
    p {  font-size: 1.2rem;}
    body {  margin: 0;}
    .topnav { overflow: hidden; background-color: #07508c; color: rgb(0, 0, 0); font-size: 1.7rem; }
    .content { padding: 20px; }
    .card { background-color: rgb(255, 255, 255); box-shadow: 2px 2px 12px 1px rgba(140,140,140,.5); }
    .cards { max-width: 700px; margin: 0 auto; display: grid; grid-gap: 2rem; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); }
    .reading { font-size: 2.8rem; }
    .card.temperature { color: #544bd6; }
    .card.humidity { color: #17bebb; }
    .card.pressure { color: #d9415f; }
  </style>
</head>
<body>
  <div class="topnav">
    <h2><u>Raspberry Pico W Web Server using DHT11 Sensor</u></h2>
  </div>
  <div class="content">
    <div class="cards">
      <div class="card temperature">
        <h4><i class="fas fa-thermometer-half"></i>TEMPERATURE Celsius</h4><p><span class="reading">""" + str(temperature) + """ &#8451; </p>
      </div>
      <div class="card pressure">
        <h4><i class="fas fa-angle-double-down"></i> HUMIDITY</h4><p><span class="reading">""" + str(humidity) + """ %</p>
      </div>
    </div>
  </div>
</body>

</html>"""
    return html

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.bind(('', 80))
s.listen(5)

while True:
    try:
     
        if gc.mem_free() < 102000:
            gc.collect()
        conn, addr = s.accept()
        conn.settimeout(3.0)
        print('Got a connection from %s' % str(addr))
        request = conn.recv(1024)
        conn.settimeout(None)
        request = str(request)
        print('Content = %s' % request)
        # Read sensor data
        dht_sensor.measure()
        # Get temperature and humidity values
        temperature = dht_sensor.temperature()
        humidity = dht_sensor.humidity()
        print(f'Temperature: {temperature}°C | Humidity: {humidity}%')
        lcd.move_to(0,0)
        lcd.putstr("Weather Station")
        lcd.move_to(0,1)
        lcd.putstr("                ")
        lcd.move_to(0,1)
        lcd.putstr("Temp: ")
        lcd.putstr(str(temperature))
        lcd.putstr(chr (0xDF) + "C")
        time.sleep(8)
        lcd.move_to(0,1)
        lcd.putstr("                ")
        lcd.move_to(0,1)
        lcd.putstr("Humidity: ")
        lcd.putstr(str (humidity))
        lcd.putstr("%")
        time.sleep(2)
        response = web_page()
        conn.send('HTTP/1.1 200 OK\n')
        conn.send('Content-Type: text/html\n')
        conn.send('Connection: close\n\n')
        conn.sendall(response)
        conn.close()
        

    except OSError as e:
        conn.close()
        print('Connection closed')
        #print(f'Error reading DHT11 sensor: {e}')
