#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>

#define FIREBASE_HOST "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx.firebaseio.com"   // Enter firebase DB URL without "https:// "  and "/" at the end of URL             
#define FIREBASE_AUTH "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"   // Real-time database secret key here

#define WIFI_SSID "xxxxxxxxxxxx" // WIFI SSID here                                   
#define WIFI_PASSWORD "xxxxxxxxxx"   // WIFI password here                  

// Declare the Firebase Data object in the global scope
FirebaseData firebaseData1;
FirebaseData firebaseData2;

int device_1 = 0; //GPIO0 Pin number on which sensor is connected
int device_2 = 2; //GPIO0 Pin number on which buzzer is connected
String switch_data1;
String switch_data2;

void setup() 
{
  pinMode(device_1, OUTPUT);
  pinMode(device_2, OUTPUT);

  Serial.begin(9600);
  Serial.println("Serial communication started\n");
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);  //connect with wifi
  Serial.print("Connecting to ");
  Serial.print(WIFI_SSID);
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(100);
  }
  Serial.println();
  Serial.print("Connected to ");
  Serial.println(WIFI_SSID);
  Serial.print("IP Address is : ");
  Serial.println(WiFi.localIP());  //print local IP address
  Firebase.begin(FIREBASE_HOST, FIREBASE_AUTH);  // connect to firebase
  Firebase.reconnectWiFi(true);
  delay(500);
}

void read_data()
{
   Firebase.getString(firebaseData1, "/switch/switch_data1");
   switch_data1 = firebaseData1.stringData();
   delay(10);
  
   Firebase.getString(firebaseData2, "/switch/switch_data2");
   switch_data2 = firebaseData2.stringData();
   delay(10);
}
   
void loop() 
{
 read_data();
 if(switch_data1 == "1")
  {
   Serial.println("Device 1 ON");
   digitalWrite(device_1, HIGH); 
  }
  else if(switch_data1 == "0")
  {
    Serial.println("Device 1 OFF");
    digitalWrite(device_1, LOW); 
  }
  
  if(switch_data2 == "1")
  {
   Serial.println("Device 2 ON");
   digitalWrite(device_2, HIGH); 
  }
  else if(switch_data2 == "0")
  {
    Serial.println("Device 2 OFF");
    digitalWrite(device_2, LOW);
  }
}
